<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">
        <i class="bi bi-pencil me-2"></i>Edit Pelatihan
    </h2>
    <a href="<?= base_url('admin/training') ?>" class="btn btn-secondary">
        <i class="bi bi-arrow-left me-1"></i>Kembali
    </a>
</div>

<?php if (session()->getFlashdata('errors')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <ul class="mb-0">
            <?php foreach (session()->getFlashdata('errors') as $error): ?>
                <li><?= $error ?></li>
            <?php endforeach; ?>
        </ul>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="admin-card">
    <form action="<?= base_url('admin/training/update/' . $training['id']) ?>" method="POST" enctype="multipart/form-data">
        <?= csrf_field() ?>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="nama_pelatihan" class="form-label">Nama Pelatihan <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="nama_pelatihan" name="nama_pelatihan" 
                       value="<?= old('nama_pelatihan', $training['nama_pelatihan']) ?>" required>
            </div>
            <div class="col-md-6 mb-3">
                <label for="penyelenggara" class="form-label">Penyelenggara</label>
                <input type="text" class="form-control" id="penyelenggara" name="penyelenggara" 
                       value="<?= old('penyelenggara', $training['penyelenggara'] ?? '') ?>">
            </div>
        </div>

        <div class="row">
            <div class="col-md-4 mb-3">
                <label for="tanggal_mulai" class="form-label">Tanggal Mulai</label>
                <input type="date" class="form-control" id="tanggal_mulai" name="tanggal_mulai" 
                       value="<?= old('tanggal_mulai', $training['tanggal_mulai'] ?? '') ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="tanggal_selesai" class="form-label">Tanggal Selesai</label>
                <input type="date" class="form-control" id="tanggal_selesai" name="tanggal_selesai" 
                       value="<?= old('tanggal_selesai', $training['tanggal_selesai'] ?? '') ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label for="urutan" class="form-label">Urutan</label>
                <input type="number" class="form-control" id="urutan" name="urutan" 
                       value="<?= old('urutan', $training['urutan'] ?? 0) ?>" min="0">
            </div>
        </div>

        <div class="mb-3">
            <label for="deskripsi" class="form-label">
                <i class="bi bi-file-text me-1"></i>Deskripsi
            </label>
            
            <textarea class="form-control" id="deskripsi" name="deskripsi" rows="5" 
                      placeholder="Tulis deskripsi atau klik Generate AI untuk membuat otomatis..."><?= old('deskripsi', $training['deskripsi'] ?? '') ?></textarea>
            
            <!-- AI Generate Button -->
            <button type="button" class="btn btn-outline-primary btn-sm position-absolute ai-generate-btn" 
                    style="top: 35px; right: 10px; z-index: 10;" 
                    id="generateDescriptionBtn" onclick="generateTrainingDescription()">
                <i class="bi bi-magic" id="generateIcon"></i>
                <span id="generateText">Generate AI</span>
            </button>
            
            <!-- AI Status -->
            <div class="ai-status mt-2" id="aiStatus" style="display: none;">
                <div class="alert alert-info alert-sm">
                    <i class="bi bi-robot me-1"></i>
                    <span id="aiStatusText">Sedang menggenerate deskripsi...</span>
                </div>
            </div>
        </div>

        <div class="mb-3">
            <label for="sertifikat" class="form-label">Sertifikat</label>
            <?php if ($training['sertifikat'] ?? null): ?>
                <div class="mb-2">
                    <p class="text-white small">
                        <i class="bi bi-file-earmark-pdf me-1"></i>Sertifikat saat ini tersedia
                    </p>
                </div>
            <?php endif; ?>
            <input type="file" class="form-control" id="sertifikat" name="sertifikat" 
                   accept="image/jpeg,image/png,application/pdf">
            <small class="text-white">Format: JPG, PNG, PDF (Max: 5MB). Kosongkan jika tidak ingin mengubah.</small>
        </div>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary">
                <i class="bi bi-save me-1"></i>Update
            </button>
            <a href="<?= base_url('admin/training') ?>" class="btn btn-secondary">
                <i class="bi bi-x me-1"></i>Batal
            </a>
        </div>
    </form>
</div>
<?= $this->endSection() ?>

<script src="<?= base_url('assets/js/ai-generator.js') ?>"></script>
<script>
// Initialize AI Generator UI for Training Edit
document.addEventListener('DOMContentLoaded', function() {
    // Auto-fill AI input when nama_pelatihan changes
    const namaPelatihan = document.getElementById('nama_pelatihan');
    if (namaPelatihan) {
        namaPelatihan.addEventListener('input', function() {
            const aiInput = document.getElementById('aiInput');
            if (aiInput && this.value) {
                aiInput.value = `Saya mengikuti pelatihan "${this.value}". Tolong buatkan deskripsi yang menjelaskan manfaat dan pembelajaran dari pelatihan ini.`;
            }
        });
    }
});
</script>


